package de.javafleet.network;

import java.net.URI;
import java.net.http.*;
import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * 🎯 CHALLENGE: Netzwerkprogrammierung meistern
 * 
 * Löse die folgenden Aufgaben, indem du die TODOs implementierst.
 */
public class NetworkChallenge {
    
    public static void runChallenges() throws Exception {
        System.out.println("=== Netzwerk Challenges ===");
        System.out.println();
        
        level1();
        level2();
        level3();
    }
    
    // ========================================
    // 🟢 LEVEL 1: Grundlagen
    // ========================================
    
    static void level1() throws Exception {
        System.out.println("--- Level 1: Grundlagen ---");
        
        // TODO 1.1: Rufe die GitHub API auf und gib den Status aus
        // URL: https://api.github.com/users/octocat
        System.out.println("  1.1 GitHub API aufrufen:");
        // HttpClient client = ...
        // HttpRequest request = ...
        // HttpResponse<String> response = ...
        // System.out.println("    Status: " + response.statusCode());
        
        // TODO 1.2: Extrahiere den "name" aus der JSON-Antwort
        // Tipp: Einfaches String-Parsing oder Regex
        System.out.println("  1.2 Name extrahieren:");
        
        // TODO 1.3: Rufe https://httpbin.org/get auf und zeige die Headers
        System.out.println("  1.3 Headers anzeigen:");
        
        System.out.println();
    }
    
    // ========================================
    // 🟡 LEVEL 2: POST Requests
    // ========================================
    
    static void level2() throws Exception {
        System.out.println("--- Level 2: POST Requests ---");
        
        // TODO 2.1: Sende einen POST-Request an jsonplaceholder.typicode.com
        // URL: https://jsonplaceholder.typicode.com/posts
        // Body: {"title": "Mein Titel", "body": "Mein Text", "userId": 1}
        System.out.println("  2.1 POST Request senden:");
        
        // TODO 2.2: Setze Content-Type Header auf "application/json"
        System.out.println("  2.2 Mit korrektem Content-Type:");
        
        System.out.println();
    }
    
    // ========================================
    // 🔵 LEVEL 3: Async & Parallel
    // ========================================
    
    static void level3() throws Exception {
        System.out.println("--- Level 3: Async & Parallel ---");
        
        // TODO 3.1: Rufe 5 Posts parallel ab
        // URLs: https://jsonplaceholder.typicode.com/posts/1 bis /5
        System.out.println("  3.1 Parallele Requests:");
        
        // TODO 3.2: Miss die Zeit für sequentiell vs. parallel
        System.out.println("  3.2 Performance-Vergleich:");
        
        // TODO 3.3: Implementiere Timeout-Handling
        // Wenn ein Request länger als 5 Sekunden dauert → abbrechen
        System.out.println("  3.3 Mit Timeout:");
        
        System.out.println();
    }
}
