# 🚀 Tag 1: Deine erste Spring Boot REST API

**Spring Boot Basic – Tag 1 von 10**  
*Java Fleet Systems Consulting*

---

## 📋 Versionen

| Komponente | Version |
|------------|---------|
| Spring Boot | 3.4.5 |
| Java | 21 (Minimum: 17) |
| Datafaker | 2.5.4 |
| Maven | 3.9+ |

---

## ⚡ Quick Start

```bash
# 1. Projekt entpacken
unzip tag1-spring-boot-basic-v2.0.zip

# 2. In den Projektordner wechseln
cd helloworldapi

# 3. Starten
mvn spring-boot:run
```

**Alternativ in NetBeans/IntelliJ:**  
File → Open Project → Ordner auswählen → Run

---

## 🔗 Endpoints

| Methode | URL | Beschreibung |
|---------|-----|-------------|
| GET | `/hello` | Hello World |
| GET | `/api/persons` | Alle Personen (100 Stück) |
| GET | `/api/persons/{id}` | Eine Person nach ID |
| GET | `/api/persons?page=0&size=10` | Paginiert |
| GET | `/api/persons/search?name=Müller` | Suche nach Name |
| GET | `/api/persons/count` | Anzahl Personen |
| GET | `/api/persons/random` | Zufällige Person |

---

## 📁 Projektstruktur

```
helloworldapi/
├── pom.xml                                         ← Maven Dependencies
├── README.md                                       ← Diese Datei
├── src/
│   ├── main/
│   │   ├── java/com/example/helloworldapi/
│   │   │   ├── HelloWorldApiApplication.java       ← Main-Klasse
│   │   │   ├── controller/
│   │   │   │   ├── HelloController.java            ← Hello World Endpoint
│   │   │   │   └── PersonController.java           ← Person REST API
│   │   │   └── model/
│   │   │       └── Person.java                     ← Person Datenklasse
│   │   └── resources/
│   │       ├── application.properties              ← Konfiguration
│   │       ├── static/                             ← CSS, JS, Bilder
│   │       └── templates/                          ← HTML Templates
│   └── test/java/com/example/helloworldapi/
│       └── HelloWorldApiApplicationTests.java      ← Basis-Test
```

---

## 🧪 Testen mit curl

```bash
# Hello World
curl http://localhost:8080/hello

# Alle Personen
curl http://localhost:8080/api/persons

# Person nach ID
curl http://localhost:8080/api/persons/1

# Nicht existierende Person (→ 404)
curl -v http://localhost:8080/api/persons/999

# Paginierung: Erste 5 Personen
curl "http://localhost:8080/api/persons?page=0&size=5"

# Suche nach Name
curl "http://localhost:8080/api/persons/search?name=Müller"

# Anzahl
curl http://localhost:8080/api/persons/count

# Zufällige Person
curl http://localhost:8080/api/persons/random
```

---

## 🔧 Troubleshooting

**Port 8080 belegt?**  
In `application.properties` ändern: `server.port=9000`

**Maven Dependencies nicht geladen?**  
`mvn clean install` im Terminal ausführen.

**JSON kommt nicht?**  
Prüfe ob `spring-boot-starter-web` in der `pom.xml` ist.

---

## 📚 Zum Blogpost

👉 [Tag 1: Deine erste Spring Boot REST API](https://www.java-developer.online/tag-1-deine-erste-spring-boot-rest-app/)

---

## 📅 Nächster Tag

**Tag 2:** Spring Container & Dependency Injection + CRUD

---

*© 2025 Java Fleet Systems Consulting*  
*Autorin: Elyndra Valen*
