package com.example.helloworldapi.controller;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Dein erster REST Controller!
 * 
 * @RestController = @Controller + @ResponseBody
 * → Alle Methoden geben direkt Daten zurück (kein HTML-Template)
 */
@RestController
public class HelloController {

    /**
     * GET http://localhost:8080/hello
     * 
     * @GetMapping registriert diese Methode für HTTP GET Requests.
     * Spring konvertiert den Return-Wert automatisch zu einer HTTP Response.
     */
    @GetMapping("/hello")
    public String hello() {
        return "Hello World from Spring Boot!";
    }
}
