package com.example.helloworldapi.model;

import java.util.Objects;

/**
 * Person Model-Klasse.
 * 
 * Repräsentiert eine Person mit ID, Vor-/Nachname und Email.
 * Jackson nutzt die Getter, um Java-Objekte automatisch in JSON zu konvertieren.
 * 
 * Hinweis: Ab Tag 2 lernst du Records und Lombok als Alternative
 * zu handgeschriebenen Gettern/Settern kennen.
 */
public class Person {

    private Long id;
    private String firstname;
    private String lastname;
    private String email;

    // Default-Konstruktor - Jackson braucht ihn für JSON → Java Konvertierung
    public Person() {
    }

    public Person(Long id, String firstname, String lastname, String email) {
        this.id = id;
        this.firstname = firstname;
        this.lastname = lastname;
        this.email = email;
    }

    // --- Getter und Setter ---

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFirstname() {
        return firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    // --- Best Practice: toString, equals, hashCode ---

    @Override
    public String toString() {
        return "Person{" +
                "id=" + id +
                ", firstname='" + firstname + '\'' +
                ", lastname='" + lastname + '\'' +
                ", email='" + email + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Person person = (Person) o;
        return Objects.equals(id, person.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
